close("*");
IMAGEXT=".tif";
path=getDirectory("Select a folder...");
cNames=newArray("LifeR", "GFP-X");
SEGMENT=1;
ERODE=1;

SIGMA=3; // Sigma for blurring to make mask
BG=50; // Background subtraction radius for making mask
ANSIGMA=0; // Sigma for blurring for analysis
ANBG=20; // BG subtract radius for analysis
METHOD="Li"; // threshold method for making mask

REGRESSION="Bisection"; // Use either bisection (faster) or costes (slower but closer to 'original' algorithm)
REGRESSION="Costes";

run("Options...", "iterations=1 count=1 black do=Nothing");
Table.create("files");
if(roiManager("count")>0)
	roiManager("reset");
threshAndColoc(path);

function threshAndColoc(path)
	{
	fl=getFileList(path);
	files=newArray(fl.length);
	counts=newArray(fl.length);
	for(i=0; i<fl.length; i++)
		{
		// THIS IS THE PART THAT DOES THE RECURSION
		if(File.isDirectory(path+fl[i]))
			{
			threshAndColoc(path + fl[i]);
			}

		if(endsWith(fl[i],IMAGEXT)==true)
			{
			Table.set("file", Table.size, fl[i], "files");
			Table.update("files");
			open(path+fl[i]);
			run("Select All");
			getDimensions(width, height, channels, slices, frames);
			chs=newArray(channels);
			for(c=0; c<channels; c++)
				{
				chs[c]="C"+parseInt(c+1);
				}
			segmentCell(fl[i]);
			coloc(fl[i]);
			}
		}
	}


function segmentCell(imp)
	{
	selectImage(imp);
	run("Select All");
	if(SEGMENT==0)
		{
		run("Duplicate...", "title=mask duplicate channels=2-3"); //mask for whole cell
		run("Split Channels");
		imageCalculator("Average create 32-bit stack", "C1-mask", "C2-mask");
		}
		else run("Duplicate...", "title=mask duplicate channels="+SEGMENT); //mask for whole cell
	run("Gaussian Blur...", "sigma="+SIGMA+" stack");
	setAutoThreshold(METHOD+" dark stack");
	run("Convert to Mask", "method="+METHOD+" background=Dark black");
	run("Fill Holes", "stack");
	for(e=0; e<ERODE; e++)
		run("Erode", "stack");
	rename("mask2");

	getDimensions(width, height, channels, slices, frames);
	setThreshold(127, 255);
	for(s=0; s<slices; s++)
		{
		Stack.setSlice(s);
		run("Create Selection");
		if(selectionType()>-1)
			{roiManager("add");}
		}
	saveROIs(path, fl[i], "mask");
	roiManager("reset");
	}


function saveROIs(path, imp, suffix)
	{
	rois=newArray(roiManager("count"));
	for (n=0; n<rois.length; n++)
		{
		rois[n]=n;
		}
	roiManager("select", rois);
	roiManager("Save", path+"\\"+stripX(imp)+suffix+".zip");
	}

function coloc(imp)
	{
	selectImage(imp);
	if(ANBG>0)
		run("Subtract Background...", "rolling="+ANBG+ " sliding stack");
		
	if(ANSIGMA>0)
		run("Gaussian Blur...", "sigma="+ANSIGMA+" stack");
	
	run("Split Channels");
	for (i=0; i<channels-1; i++)
		{
		for (j=i+1; j<channels; j++)
			{
			run("Coloc 2","channel_1=["+chs[i]+"-"+imp+"] channel_2=["+chs[j]+"-"+imp+"] roi_or_mask=mask2 threshold_regression="+REGRESSION+" display_images_in_result li_histogram_channel_1 li_histogram_channel_2 li_icq spearman's_rank_correlation manders'_correlation 2d_instensity_histogram costes'_significance_test psf=3 costes_randomisations=10");		
			
			selectWindow("Log");
			saveAs("Text", path+"\\"+stripX(imp)+"_"+cNames[i]+"_"+cNames[j]);
			selectWindow("Log");
			run("Close");
			}
		}
	close("*");
	}
	
	
function stripX(string)
	{
	// This is because Macro language doesn't have a general use name without extension
	return substring(string, 0, lastIndexOf(string, "."));
	}

	
		
	
// Do Coloc2
